/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.graphics.VertexList;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class GPolygon
extends GObject
implements GFillable,
GScalable {
    private double xScale;
    private double yScale;
    private double rotation;
    private VertexList vertices = new VertexList();
    private boolean cacheValid;
    private boolean complete;
    private Polygon poly;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 1L;

    public GPolygon() {
        this.clear();
    }

    public GPolygon(double d, double d2) {
        this();
        this.setLocation(d, d2);
    }

    public GPolygon(GPoint[] gPointArray) {
        this();
        this.vertices.add(gPointArray);
        this.markAsComplete();
    }

    public void addVertex(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add vertices to a GPolygon that has been marked as complete.");
        }
        this.vertices.addVertex(d, d2);
    }

    public void addEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(d, d2);
    }

    public final void addPolarEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(d * GMath.cosDegrees(d2), -d * GMath.sinDegrees(d2));
    }

    public void addArc(double d, double d2, double d3, double d4) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addArc(d, d2, d3, d4);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.getCurrentPoint();
    }

    public void scale(double d, double d2) {
        this.xScale *= d;
        this.yScale *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    public void rotate(double d) {
        this.rotation += d;
        this.repaint();
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public GRectangle getBounds() {
        return this.vertices.getBounds(this.getX(), this.getY(), this.xScale, this.yScale, this.rotation);
    }

    public boolean contains(double d, double d2) {
        return this.vertices.contains((d - this.getX()) / this.xScale, (d2 - this.getY()) / this.yScale);
    }

    public void paint(Graphics graphics) {
        if (this.vertices.size() == 0) {
            return;
        }
        Polygon polygon = this.getPolygon();
        if (this.isFilled()) {
            graphics.setColor(this.getFillColor());
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setColor(this.getColor());
        }
        graphics.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void recenter() {
        this.vertices.recenter();
        this.cacheValid = false;
    }

    public Object clone() {
        try {
            GPolygon gPolygon = (GPolygon)super.clone();
            gPolygon.vertices = new VertexList(gPolygon.vertices);
            return gPolygon;
        }
        catch (Exception exception) {
            throw new ErrorException("Impossible exception");
        }
    }

    protected void repaint() {
        this.cacheValid = false;
        super.repaint();
    }

    protected Polygon getPolygon() {
        if (this.cacheValid) {
            return this.poly;
        }
        this.poly = this.vertices.createPolygon(this.getX(), this.getY(), this.xScale, this.yScale, this.rotation);
        this.cacheValid = true;
        return this.poly;
    }

    protected void markAsComplete() {
        this.complete = true;
    }

    protected void clear() {
        if (this.complete) {
            throw new ErrorException("You can't clear a GPolygon that has been marked as complete.");
        }
        this.vertices.clear();
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.cacheValid = false;
    }
}

