/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class HexByteOutputStream
extends OutputStream {
    private static final int COLUMNS = 76;
    private int columnCount;
    private PrintStream out;

    public HexByteOutputStream(PrintStream printStream) {
        this.out = printStream;
        this.out.flush();
        this.columnCount = 0;
    }

    public void write(int n) throws IOException {
        String string = Integer.toHexString(256 + (n & 0xFF)).toUpperCase();
        this.out.write(string.charAt(1));
        this.out.write(string.charAt(2));
        this.columnCount += 2;
        if (this.columnCount >= 76) {
            this.columnCount = 0;
            this.out.println();
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

