/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.SoundPlayer;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundClip
implements AudioClip {
    public static final int MONO = 1;
    public static final int STEREO = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final double STANDARD_FRAME_RATE = 22050.0;
    public static final int MAX_SAMPLE = Short.MAX_VALUE;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BUFFER_INCREMENT = 10000;
    private AudioFormat format;
    private SoundPlayer player;
    private String soundName;
    private double clipVolume;
    private float frameRate;
    private int nChannels;
    private int frameCount;
    private int currentFrame;
    private byte[] data;

    public SoundClip() {
        this(1);
    }

    public SoundClip(int n) {
        if (n < 1 || n > 2) {
            throw new ErrorException("SoundClip: Illegal number of channels");
        }
        this.nChannels = n;
        this.frameRate = 22050.0f;
        this.soundName = "Untitled";
        this.frameCount = 0;
        this.clipVolume = 1.0;
        this.data = new byte[0];
        this.format = new AudioFormat(this.frameRate, 16, n, true, true);
    }

    public SoundClip(String string) {
        if (string.startsWith("http:")) {
            try {
                URL uRL = new URL(string);
                this.soundName = JTFTools.getURLSuffix(uRL.getPath());
                this.readSound(this.convertToPCM(this.getAudioInputStream(uRL.openStream())));
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        } else {
            this.soundName = string;
            this.readSound(this.convertToPCM(this.getAudioInputStream(new File(string))));
        }
    }

    public SoundClip(File file) {
        try {
            this.soundName = file.getName();
            this.readSound(this.convertToPCM(this.getAudioInputStream(file)));
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    public SoundClip(URL uRL) {
        try {
            this.soundName = JTFTools.getURLSuffix(uRL.getPath());
            this.readSound(this.convertToPCM(this.getAudioInputStream(uRL.openStream())));
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    public SoundClip(InputStream inputStream) {
        this.soundName = "Untitled";
        this.readSound(this.convertToPCM(this.getAudioInputStream(inputStream)));
    }

    public SoundClip(int[] nArray) {
        this(1);
        this.addSampleData(nArray);
    }

    public SoundClip(int[] nArray, int[] nArray2) {
        this(2);
        this.addSampleData(nArray, nArray2);
    }

    public synchronized void play() {
        if (this.player == null) {
            this.player = new SoundPlayer(this);
        }
        this.player.play();
    }

    public void loop() {
        if (this.player == null) {
            this.player = new SoundPlayer(this);
        }
        this.player.loop();
    }

    public synchronized void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void save(String string) {
        this.save(new File(System.getProperty("user.dir"), string));
    }

    public void save(File file) {
        try {
            AudioSystem.write(this.getAudioInputStream(), this.getFormatForFile(file.getName()), file);
        }
        catch (IOException iOException) {
            throw new ErrorException("save: I/O error - " + iOException.getMessage());
        }
    }

    public String getName() {
        return this.soundName;
    }

    public void setName(String string) {
        this.soundName = string;
    }

    public int getChannelCount() {
        return this.nChannels;
    }

    public boolean isStereo() {
        return this.nChannels == 2;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public double getDuration() {
        return (float)this.frameCount / this.frameRate;
    }

    public int getFrameIndex() {
        return this.currentFrame;
    }

    public void setFrameIndex(int n) {
        this.currentFrame = n;
    }

    public void rewind() {
        this.setFrameIndex(0);
    }

    public double getVolume() {
        return this.clipVolume;
    }

    public void setVolume(double d) {
        this.clipVolume = d;
    }

    public int[] getSampleData() {
        return this.getSampleData(0);
    }

    public int[] getSampleData(int n) {
        this.standardize();
        if (n < 0 || n >= this.nChannels) {
            throw new ErrorException("getSamples: Channel number out of range");
        }
        int[] nArray = new int[this.frameCount];
        int n2 = n * 2;
        for (int i = 0; i < this.frameCount; ++i) {
            nArray[i] = this.data[n2] << 8 | this.data[n2 + 1] & 0xFF;
            n2 += this.nChannels * 2;
        }
        return nArray;
    }

    public void addSampleData(int n) {
        this.standardize();
        if (this.nChannels == 2) {
            this.addSampleData(n, n);
        } else {
            int n2 = this.frameCount * 2;
            ++this.frameCount;
            if (n2 >= this.data.length) {
                byte[] byArray = new byte[n2 + 10000];
                if (n2 > 0) {
                    System.arraycopy(this.data, 0, byArray, 0, n2);
                }
                this.data = byArray;
            }
            this.data[n2++] = (byte)(n >> 8);
            this.data[n2++] = (byte)(n & 0xFF);
        }
    }

    public void addSampleData(int n, int n2) {
        this.standardize();
        if (this.nChannels != 2) {
            throw new ErrorException("addSampleData: Sound is not stereo");
        }
        int n3 = 2 * this.frameCount * 2;
        ++this.frameCount;
        if (n3 >= this.data.length) {
            byte[] byArray = new byte[n3 + 10000];
            if (n3 > 0) {
                System.arraycopy(this.data, 0, byArray, 0, n3);
            }
            this.data = byArray;
        }
        this.data[n3++] = (byte)(n >> 8);
        this.data[n3++] = (byte)(n & 0xFF);
        this.data[n3++] = (byte)(n2 >> 8);
        this.data[n3++] = (byte)(n2 & 0xFF);
    }

    public void addSampleData(int[] nArray) {
        this.standardize();
        if (this.nChannels == 2) {
            this.addSampleData(nArray, nArray);
        } else {
            int n = this.frameCount * 2;
            this.frameCount += nArray.length;
            byte[] byArray = new byte[this.frameCount * 2];
            if (n > 0) {
                System.arraycopy(this.data, 0, byArray, 0, n);
            }
            this.data = byArray;
            for (int i = 0; i < nArray.length; ++i) {
                this.data[n++] = (byte)(nArray[i] >> 8);
                this.data[n++] = (byte)(nArray[i] & 0xFF);
            }
        }
    }

    public void addSampleData(int[] nArray, int[] nArray2) {
        this.standardize();
        if (this.nChannels != 2) {
            throw new ErrorException("addSampleData: Sound is not stereo");
        }
        if (nArray.length != nArray2.length) {
            throw new ErrorException("addSampleData: Channels have unequal length");
        }
        int n = 2 * this.frameCount * 2;
        this.frameCount += nArray.length;
        byte[] byArray = new byte[2 * this.frameCount * 2];
        if (n > 0) {
            System.arraycopy(this.data, 0, byArray, 0, n);
        }
        this.data = byArray;
        for (int i = 0; i < nArray.length; ++i) {
            this.data[n++] = (byte)(nArray[i] >> 8);
            this.data[n++] = (byte)(nArray[i] & 0xFF);
            this.data[n++] = (byte)(nArray2[i] >> 8);
            this.data[n++] = (byte)(nArray2[i] & 0xFF);
        }
    }

    public String toString() {
        String string = this.soundName;
        string = string + " (";
        string = string + (this.nChannels == 1 ? "mono" : "stereo");
        string = string + ", ";
        string = string + new DecimalFormat("#0.00").format(this.getDuration());
        string = string + " sec)";
        return string;
    }

    public static double sampleToIntensity(int n) {
        return Math.max(-1.0, Math.min(1.0, (double)n / 32767.0));
    }

    public static int intensityToSample(double d) {
        return (int)Math.round(Math.max(-1.0, Math.min(1.0, d)) * 32767.0);
    }

    protected byte[] getData() {
        return this.data;
    }

    protected AudioFormat getFormat() {
        return this.format;
    }

    protected AudioInputStream getAudioInputStream() {
        return new AudioInputStream(new ByteArrayInputStream(this.data), this.format, this.frameCount);
    }

    private void standardize() {
        if ((double)this.frameRate == 22050.0) {
            return;
        }
        double d = 22050.0 / (double)this.frameRate;
        int n = (int)((double)this.frameCount * d);
        byte[] byArray = new byte[this.nChannels * n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.nChannels; ++j) {
                int n3 = (int)((double)i / d) * 2 * this.nChannels + 2 * j;
                int n4 = this.data[n3] << 8 | this.data[n3 + 1] & 0xFF;
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)(n4 & 0xFF);
            }
        }
        this.data = byArray;
        this.frameCount = n;
        this.format = new AudioFormat(this.frameRate, 16, this.nChannels, true, true);
    }

    private AudioFileFormat.Type getFormatForFile(String string) {
        if ((string = string.toLowerCase()).endsWith(".wav")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (string.endsWith(".aif")) {
            return AudioFileFormat.Type.AIFF;
        }
        if (string.endsWith(".aiff")) {
            return AudioFileFormat.Type.AIFF;
        }
        return AudioFileFormat.Type.AU;
    }

    private void readSound(AudioInputStream audioInputStream) {
        this.format = audioInputStream.getFormat();
        this.nChannels = this.format.getChannels();
        this.frameRate = this.format.getFrameRate();
        long l = audioInputStream.getFrameLength();
        if (l > Integer.MAX_VALUE) {
            throw new ErrorException("SoundClip: Sound file is too large");
        }
        this.frameCount = (int)l;
        this.data = this.frameCount < 0 ? new byte[10000] : new byte[this.frameCount * this.nChannels * 2];
        int n = 0;
        boolean bl = false;
        while (!bl) {
            int n2;
            for (int i = this.data.length - n; i > 0; i -= n2) {
                try {
                    n2 = audioInputStream.read(this.data, n, i);
                    if (n2 == 0) {
                        bl = true;
                        break;
                    }
                    n += n2;
                    continue;
                }
                catch (IOException iOException) {
                    throw new ErrorException(iOException);
                }
            }
            if (this.frameCount >= 0) {
                bl = true;
            }
            if (bl) continue;
            byte[] byArray = new byte[2 * this.data.length];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
        if (n < this.data.length && this.frameCount < 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n);
            this.data = byArray;
        }
        if (this.frameCount < 0) {
            this.frameCount = n / (2 * this.nChannels);
        }
    }

    private AudioInputStream convertToPCM(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        audioFormat = new AudioFormat(audioFormat.getSampleRate(), 16, audioFormat.getChannels(), true, true);
        return AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getAudioInputStream(InputStream inputStream) {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            return AudioSystem.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new ErrorException(this.createUnsupportedFormatMessage());
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private AudioInputStream getAudioInputStream(File file) {
        try {
            return AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new ErrorException(this.createUnsupportedFormatMessage());
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private String createUnsupportedFormatMessage() {
        int n = this.soundName.lastIndexOf(46);
        if (n == -1) {
            return "Unsupported audio file format";
        }
        return "The " + this.soundName.substring(n + 1) + " format is not supported by JavaSound";
    }
}

