/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.gui.TableLayout;
import acm.program.Program;
import acm.util.JTFTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SubmitOptions
implements ActionListener,
DocumentListener {
    private static final int FIELD_WIDTH = 300;
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 230;
    private static final int SMTP_PORT = 25;
    private Component parent;
    private JDialog dialog;
    private JTextField authorNameField;
    private JTextField authorEMailField;
    private JTextField instructorEMailField;
    private JTextField smtpServerField;
    private JButton cancelButton;
    private JButton submitButton;
    private boolean submitFlag;

    public SubmitOptions(Program program) {
        this.parent = program;
        this.authorNameField = new JTextField();
        this.authorEMailField = new JTextField();
        this.instructorEMailField = new JTextField();
        this.smtpServerField = new JTextField();
        this.cancelButton = new JButton("Cancel");
        this.submitButton = new JButton("Submit");
        this.authorEMailField.getDocument().addDocumentListener(this);
        this.instructorEMailField.getDocument().addDocumentListener(this);
        this.smtpServerField.getDocument().addDocumentListener(this);
        this.cancelButton.addActionListener(this);
        this.submitButton.addActionListener(this);
        this.initPreferences(program);
    }

    public String getAuthorName() {
        return this.authorNameField.getText().trim();
    }

    public String getAuthorEMail() {
        return this.authorEMailField.getText().trim();
    }

    public String getSubmissionEMail() {
        return this.instructorEMailField.getText().trim();
    }

    public String getSMTPServer() {
        return this.smtpServerField.getText().trim();
    }

    public boolean isComplete() {
        if (this.getAuthorEMail().indexOf(64) == -1) {
            return false;
        }
        if (this.getSubmissionEMail().indexOf(64) == -1) {
            return false;
        }
        return this.getSMTPServer().length() != 0;
    }

    public boolean popup() {
        Frame frame = JTFTools.getEnclosingFrame(this.parent);
        if (frame == null) {
            return false;
        }
        this.dialog = new JDialog(frame, "Submit Project Options", true);
        Container container = this.dialog.getContentPane();
        container.setLayout(new TableLayout(6, 2, 0, 4));
        container.add(new JLabel("Instructor email ", 4));
        container.add((Component)this.instructorEMailField, "width=300");
        container.add(new JLabel("Author name ", 4));
        container.add((Component)this.authorNameField, "width=300");
        container.add(new JLabel("Author email ", 4));
        container.add((Component)this.authorEMailField, "width=300");
        container.add(new JLabel("SMTP server ", 4));
        container.add((Component)this.smtpServerField, "width=300");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.cancelButton);
        jPanel.add(this.submitButton);
        container.add(new JLabel(""));
        container.add((Component)jPanel, "top=10");
        this.dialog.setSize(500, 230);
        this.submitFlag = false;
        this.submitButton.setEnabled(this.isComplete());
        this.dialog.setVisible(true);
        return this.submitFlag;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.submitFlag = actionEvent.getSource() == this.submitButton;
        this.dialog.setVisible(false);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.submitButton.setEnabled(this.isComplete());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.submitButton.setEnabled(this.isComplete());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.submitButton.setEnabled(this.isComplete());
    }

    private void initPreferences(Program program) {
        String string;
        this.instructorEMailField.setText(this.getDefaultField("INSTRUCTOR_EMAIL", program));
        this.authorNameField.setText(this.getDefaultField("AUTHOR_NAME", program));
        String string2 = this.getDefaultField("AUTHOR_EMAIL", program);
        if (string2.length() == 0) {
            string2 = System.getProperty("user.name");
            if (string2 == null) {
                string2 = "";
            } else {
                string = JTFTools.getLocalHostName();
                if (string != null) {
                    string2 = string2 + "@" + string;
                }
            }
        }
        this.authorEMailField.setText(string2);
        string = this.getDefaultField("SMTP_SERVER", program);
        if (string.length() == 0 && (string = System.getProperty("mail.smtp.host")) == null) {
            String string3 = JTFTools.getLocalHostName();
            if (string3 == null) {
                string = "";
            } else {
                string = "smtp." + string3.substring(string3.indexOf(46) + 1);
                try {
                    new Socket(string, 25).close();
                }
                catch (Exception exception) {
                    string = "";
                }
            }
        }
        this.smtpServerField.setText(string);
    }

    private String getDefaultField(String string, Program program) {
        try {
            Field field = program.getClass().getField(string);
            String string2 = (String)field.get(program);
            if (string2 != null && string2.trim().length() != 0) {
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

