/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import java.awt.Graphics;

public class GLine
extends GObject
implements GScalable {
    public static final double LINE_TOLERANCE = 1.5;
    private double dx;
    private double dy;
    static final long serialVersionUID = 1L;

    public GLine(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2);
        this.dx = d3 - d;
        this.dy = d4 - d2;
    }

    public void paint(Graphics graphics) {
        double d = this.getX();
        double d2 = this.getY();
        graphics.drawLine(GMath.round(d), GMath.round(d2), GMath.round(d + this.dx), GMath.round(d2 + this.dy));
    }

    public GRectangle getBounds() {
        double d = Math.min(this.getX(), this.getX() + this.dx);
        double d2 = Math.min(this.getY(), this.getY() + this.dy);
        return new GRectangle(d, d2, Math.abs(this.dx), Math.abs(this.dy));
    }

    public void setStartPoint(double d, double d2) {
        this.dx += this.getX() - d;
        this.dy += this.getY() - d2;
        this.setLocation(d, d2);
    }

    public GPoint getStartPoint() {
        return this.getLocation();
    }

    public void setEndPoint(double d, double d2) {
        this.dx = d - this.getX();
        this.dy = d2 - this.getY();
        this.repaint();
    }

    public GPoint getEndPoint() {
        return new GPoint(this.getX() + this.dx, this.getY() + this.dy);
    }

    public void scale(double d, double d2) {
        this.dx *= d;
        this.dy *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = d3 + this.dx;
        double d6 = d4 + this.dy;
        double d7 = 2.25;
        if (this.distanceSquared(d, d2, d3, d4) < d7) {
            return true;
        }
        if (this.distanceSquared(d, d2, d5, d6) < d7) {
            return true;
        }
        if (d < Math.min(d3, d5) - 1.5) {
            return false;
        }
        if (d > Math.max(d3, d5) + 1.5) {
            return false;
        }
        if (d2 < Math.min(d4, d6) - 1.5) {
            return false;
        }
        if (d2 > Math.max(d4, d6) + 1.5) {
            return false;
        }
        if ((float)d3 - (float)d5 == 0.0f && (float)d4 - (float)d6 == 0.0f) {
            return false;
        }
        double d8 = ((d - d3) * (d5 - d3) + (d2 - d4) * (d6 - d4)) / this.distanceSquared(d3, d4, d5, d6);
        return this.distanceSquared(d, d2, d3 + d8 * (d5 - d3), d4 + d8 * (d6 - d4)) < d7;
    }

    public String paramString() {
        String string = super.paramString();
        string = string.substring(string.indexOf(41) + 1);
        GPoint gPoint = this.getStartPoint();
        String string2 = "start=(" + gPoint.getX() + ", " + gPoint.getY() + ")";
        gPoint = this.getEndPoint();
        string2 = string2 + ", end=(" + gPoint.getX() + ", " + gPoint.getY() + ")";
        return string2 + string;
    }

    private double distanceSquared(double d, double d2, double d3, double d4) {
        return (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
    }
}

