/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;

class GObjectList
implements Serializable {
    private GContainer parent;
    private ArrayList<GObject> contents;
    private ArrayList<GObject> enabledList;

    public GObjectList(GContainer gContainer) {
        this.parent = gContainer;
        this.contents = new ArrayList();
        if (this.parent instanceof GCanvas) {
            this.enabledList = new ArrayList();
        }
    }

    public synchronized void add(GObject gObject) {
        if (gObject.getParent() != null) {
            gObject.getParent().remove(gObject);
        }
        gObject.setParent(this.parent);
        this.contents.add(gObject);
        if (this.enabledList != null && gObject.areMouseListenersEnabled()) {
            this.enabledList.add(gObject);
        }
    }

    public synchronized void remove(GObject gObject) {
        this.contents.remove(gObject);
        gObject.setParent(null);
        if (this.enabledList != null) {
            this.enabledList.remove(gObject);
        }
    }

    public synchronized void removeAll() {
        this.contents.clear();
        if (this.enabledList != null) {
            this.enabledList.clear();
        }
    }

    public int getElementCount() {
        return this.contents.size();
    }

    public GObject getElement(int n) {
        return this.contents.get(n);
    }

    public synchronized GObject getElementAt(double d, double d2, boolean bl) {
        ArrayList<GObject> arrayList = bl ? this.enabledList : this.contents;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            GObject gObject = arrayList.get(i);
            if (!gObject.contains(d, d2)) continue;
            return gObject;
        }
        return null;
    }

    public synchronized void sendToFront(GObject gObject) {
        int n = this.contents.indexOf(gObject);
        if (n >= 0) {
            this.contents.remove(n);
            this.contents.add(gObject);
        }
    }

    public synchronized void sendToBack(GObject gObject) {
        int n = this.contents.indexOf(gObject);
        if (n >= 0) {
            this.contents.remove(n);
            this.contents.add(0, gObject);
        }
    }

    public synchronized void sendForward(GObject gObject) {
        int n = this.contents.indexOf(gObject);
        if (n >= 0) {
            this.contents.remove(n);
            this.contents.add(Math.min(this.contents.size(), n + 1), gObject);
        }
    }

    public synchronized void sendBackward(GObject gObject) {
        int n = this.contents.indexOf(gObject);
        if (n >= 0) {
            this.contents.remove(n);
            this.contents.add(Math.max(0, n - 1), gObject);
        }
    }

    public synchronized GRectangle getBounds() {
        GRectangle gRectangle = new GRectangle();
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                gRectangle = new GRectangle(this.contents.get(i).getBounds());
                continue;
            }
            gRectangle.add(this.contents.get(i).getBounds());
        }
        return gRectangle;
    }

    public synchronized boolean contains(double d, double d2) {
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            if (!this.contents.get(i).contains(d, d2)) continue;
            return true;
        }
        return false;
    }

    public synchronized void mapPaint(Graphics graphics) {
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            this.contents.get(i).paintObject(graphics);
        }
    }

    public synchronized boolean areMouseListenersEnabled() {
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            GObject gObject = this.contents.get(i);
            if (!gObject.areMouseListenersEnabled()) continue;
            return true;
        }
        return false;
    }

    public synchronized void updateEnabledList() {
        this.enabledList.clear();
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            GObject gObject = this.contents.get(i);
            if (!gObject.areMouseListenersEnabled()) continue;
            this.enabledList.add(gObject);
        }
    }
}

