/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private static final int PIXEL_MARGIN = 2;
    private boolean exceptionOnError;
    private double minValue;
    private double maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private NumberFormat parser = NumberFormat.getNumberInstance(Locale.US);
    private IODialog dialog;
    static final long serialVersionUID = 1L;

    public DoubleField() {
        this("", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double d) {
        this("" + d, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double d, double d2) {
        this("", d, d2);
    }

    public DoubleField(double d, double d2, double d3) {
        this("" + d, d2, d3);
    }

    private DoubleField(String string, double d, double d2) {
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(4);
        this.minValue = d;
        this.maxValue = d2;
        this.setText(string);
        this.exceptionOnError = false;
    }

    public double getValue() {
        double d;
        block9: {
            String string = this.getText().trim();
            if (string.length() == 0) {
                if (this.minValue <= 0.0 && this.maxValue >= 0.0) {
                    return 0.0;
                }
                return this.minValue;
            }
            String string2 = null;
            d = 0.0;
            try {
                d = this.parser.parse(string).doubleValue();
                if (d >= this.minValue && d <= this.maxValue) break block9;
                string2 = "Value is outside the specified range";
            }
            catch (ParseException parseException) {
                string2 = "Illegal numeric format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(string2);
            }
            String string3 = "Enter a number";
            if (this.minValue != Double.NEGATIVE_INFINITY) {
                string3 = this.maxValue != Double.POSITIVE_INFINITY ? string3 + " between " + this.minValue + " and " + this.maxValue : string3 + " greater than " + this.minValue;
            } else if (this.maxValue != Double.POSITIVE_INFINITY) {
                string3 = string3 + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            d = this.dialog.readDouble(string3, this.minValue, this.maxValue);
        }
        this.setValue(d);
        return d;
    }

    public void setValue(double d) {
        this.setText(this.formatter == null ? this.defaultFormat(d) : this.formatter.format(d));
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String string) {
        String string2 = this.getText().trim();
        double d = 0.0;
        if (string2.length() != 0) {
            try {
                d = this.parser.parse(string2).doubleValue();
            }
            catch (ParseException parseException) {
                throw new ErrorException(parseException);
            }
        }
        this.formatString = string;
        if (string == null) {
            this.formatter = null;
            this.parser = NumberFormat.getNumberInstance(Locale.US);
        } else {
            this.formatter = string.length() == 0 ? new DecimalFormat() : new DecimalFormat(string);
            this.parser = this.formatter;
        }
        if (string2.length() != 0) {
            this.setValue(d);
        }
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(60, dimension.width), Math.max(22, dimension.height));
    }

    private String defaultFormat(double d) {
        String string = "" + d;
        int n = this.getSize().width - 4;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        int n2 = string.indexOf("E");
        String string2 = "";
        if (n2 != -1) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
            try {
                d = this.parser.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                throw new ErrorException(parseException);
            }
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        String string3 = string.substring(0, string.indexOf(46) + 1);
        int n3 = n - fontMetrics.stringWidth(string3 + string2);
        if (n3 > 0) {
            int n4 = n3 / fontMetrics.stringWidth("0");
            numberFormat.setMaximumFractionDigits(n4);
            return numberFormat.format(d) + string2;
        }
        string = "";
        while (fontMetrics.stringWidth(string + "#") <= n) {
            string = string + "#";
        }
        return string;
    }
}

