/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.NullOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

class MailStream
extends PrintStream {
    private static final int SMTP_PORT = 25;
    private static SimpleDateFormat RFC2822_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private String sender;
    private String recipient;

    public MailStream(String string, String string2, String string3) {
        super(new NullOutputStream());
        try {
            this.sender = string2;
            this.recipient = string3;
            this.socket = new Socket(string, 25);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.verify("220");
            this.println("HELO " + InetAddress.getLocalHost().getHostName());
            this.verify("250");
            this.println("MAIL FROM: " + this.sender);
            this.verify("250");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                this.println("RCPT TO: " + stringTokenizer.nextToken());
                this.verify("250");
            }
            this.println("DATA");
            this.verify("354");
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void print(boolean bl) {
        this.print("" + bl);
    }

    public void print(char c) {
        this.print("" + c);
    }

    public void print(int n) {
        this.print("" + n);
    }

    public void print(long l) {
        this.print("" + l);
    }

    public void print(float f) {
        this.print("" + f);
    }

    public void print(double d) {
        this.print("" + d);
    }

    public void print(char[] cArray) {
        this.print(new String(cArray));
    }

    public void print(String string) {
        this.write(string);
    }

    public void print(Object object) {
        this.print("" + object);
    }

    public void println() {
        try {
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void write(int n) {
        try {
            if (n > 255) {
                throw new ErrorException("Illegal character in mail stream");
            }
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        try {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c > '\u00ff') {
                    throw new ErrorException("Illegal character in mail stream");
                }
                this.out.write(c);
            }
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c > '\u00ff') {
                    throw new ErrorException("Illegal character in mail stream");
                }
                this.out.write(c);
            }
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public boolean checkError() {
        return false;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void close() {
        try {
            this.println(".");
            this.verify("250");
            this.out.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void cancel() {
        try {
            this.socket.close();
            this.out.close();
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void sendStandardHeaders(String string, String string2) {
        this.println("To: " + this.recipient);
        if (string != null && string.length() != 0) {
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '-' || Character.isJavaIdentifierPart(c)) continue;
                bl = true;
                break;
            }
            this.sender = bl ? '\"' + string + '\"' + " <" + this.sender + ">" : string + " <" + this.sender + ">";
        }
        this.println("From: " + this.sender);
        if (string2 != null && string2.length() != 0) {
            this.println("Subject: " + string2);
        }
        this.println("Date: " + RFC2822_DATE_FORMAT.format(new Date()));
    }

    private void verify(String string) {
        try {
            int n;
            String string2 = "";
            while ((n = this.in.read()) != -1 && n != 10) {
                string2 = string2 + (char)n;
            }
            if (string != null && !string2.startsWith(string)) {
                throw new ErrorException("Unexpected SMTP response: " + string2);
            }
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }
}

