/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.ErrorWindow;
import acm.util.JTFTools;
import acm.util.MovieClipListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class MovieClip
extends Container {
    private static final int MIN_QUICKTIME_VERSION = 7;
    private static final int CONTROLLER_HEIGHT = 16;
    private static final int DEFAULT_TIME_SCALE = 600;
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 200);
    private Class<?> movieClass;
    private Class<?> movieControllerClass;
    private Class<?> openMovieFileClass;
    private Class<?> qdRectClass;
    private Class<?> qtDataRefClass;
    private Class<?> qtFactoryClass;
    private Class<?> qtFileClass;
    private Class<?> qtSessionClass;
    private Class<?> timeRecordClass;
    private Object controller;
    private Object movie;
    private String movieName;
    private String errorMessage;
    private int version;
    private boolean hasQuickTime;
    private boolean controllerVisible;
    private double clipVolume;
    private double clipRate;
    private static Object lock = new Object();

    public MovieClip(String string) {
        this(string, string);
    }

    public MovieClip(File file) {
        this(file, file.getName());
    }

    public MovieClip(URL uRL) {
        this(uRL, JTFTools.getURLSuffix(uRL.toString()));
    }

    public void play() {
        this.setLooping(false);
        this.startMovie();
    }

    public void loop() {
        this.setLooping(true);
        this.startMovie();
    }

    public synchronized void stop() {
        this.stopMovie();
        this.setLooping(false);
    }

    public String getName() {
        return this.movieName;
    }

    public void setName(String string) {
        this.movieName = string;
    }

    public int getFrameCount() {
        return this.getQTDuration();
    }

    public double getFrameRate() {
        return this.getQTTimeScale();
    }

    public double getDuration() {
        return (double)this.getFrameCount() / this.getFrameRate();
    }

    public int getFrameIndex() {
        return this.getCurrentTime();
    }

    public void setFrameIndex(int n) {
        this.setCurrentTime(n);
    }

    public void rewind() {
        this.setFrameIndex(0);
    }

    public double getVolume() {
        return this.clipVolume;
    }

    public void setVolume(double d) {
        this.clipVolume = d;
        this.setControllerVolume(d);
    }

    public double getPlaybackRate() {
        return this.clipRate;
    }

    public void setPlaybackRate(double d) {
        this.clipRate = d;
        if (!this.isStopped()) {
            this.setRate(d);
        }
    }

    public void enableController() {
        if (this.hasQuickTime) {
            this.setControllerVisible(true);
        }
    }

    public void disableController() {
        if (this.hasQuickTime) {
            this.setControllerVisible(false);
        }
    }

    public boolean isControllerEnabled() {
        return this.controllerVisible;
    }

    public int getControllerHeight() {
        return this.controller == null ? 0 : 16;
    }

    public Dimension getPreferredSize() {
        if (this.movie == null) {
            return DEFAULT_SIZE;
        }
        try {
            Method method = this.movieClass.getMethod("getNaturalBoundsRect", new Class[0]);
            Method method2 = this.qdRectClass.getMethod("getWidth", new Class[0]);
            Method method3 = this.qdRectClass.getMethod("getHeight", new Class[0]);
            Object object = method.invoke(this.movie, new Object[0]);
            int n = (Integer)method2.invoke(object, new Object[0]);
            int n2 = (Integer)method3.invoke(object, new Object[0]);
            Dimension dimension = new Dimension(n, n2 + this.getControllerHeight());
            return dimension;
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private MovieClip(Object object, String string) {
        this.startQuickTime();
        this.movieName = string;
        this.clipVolume = 1.0;
        this.clipRate = 1.0;
        this.setLayout(new BorderLayout());
        if (this.hasQuickTime) {
            try {
                this.readMovie(object);
            }
            catch (Exception exception) {
                this.add((Component)new ErrorWindow(string, "Can't read movie file"), "Center");
            }
        } else {
            this.add((Component)new ErrorWindow(string, this.errorMessage), "Center");
        }
        this.addComponentListener(new MovieClipListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuickTime() {
        this.hasQuickTime = false;
        try {
            this.movieClass = Class.forName("quicktime.std.movies.Movie");
            this.movieControllerClass = Class.forName("quicktime.std.movies.MovieController");
            this.openMovieFileClass = Class.forName("quicktime.io.OpenMovieFile");
            this.qdRectClass = Class.forName("quicktime.qd.QDRect");
            this.qtDataRefClass = Class.forName("quicktime.std.movies.media.DataRef");
            this.qtFactoryClass = Class.forName("quicktime.app.view.QTFactory");
            this.qtFileClass = Class.forName("quicktime.io.QTFile");
            this.qtSessionClass = Class.forName("quicktime.QTSession");
            this.timeRecordClass = Class.forName("quicktime.std.clocks.TimeRecord");
            Method method = this.qtSessionClass.getMethod("isInitialized", new Class[0]);
            Object object = lock;
            synchronized (object) {
                if (method.invoke(null, new Object[0]).equals(Boolean.FALSE)) {
                    Method method2 = this.qtSessionClass.getMethod("open", new Class[0]);
                    method2.invoke(null, new Object[0]);
                }
            }
            object = this.qtSessionClass.getMethod("getMajorVersion", new Class[0]);
            this.version = (Integer)((Method)object).invoke(null, new Object[0]);
            if (this.version < 7) {
                throw new ErrorException("MovieClip requires QuickTime V7 or later");
            }
            this.hasQuickTime = true;
        }
        catch (Exception exception) {
            this.errorMessage = exception.getMessage();
        }
    }

    private void startMovie() {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{Float.TYPE};
            Object[] objectArray = new Object[]{new Float((float)this.clipRate)};
            Method method = this.movieControllerClass.getMethod("play", classArray);
            method.invoke(this.controller, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void stopMovie() {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{Float.TYPE};
            Object[] objectArray = new Object[]{new Float(0.0)};
            Method method = this.movieControllerClass.getMethod("play", classArray);
            method.invoke(this.controller, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setLooping(boolean bl) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{Boolean.TYPE};
            Object[] objectArray = new Object[]{new Boolean(bl)};
            Method method = this.movieControllerClass.getMethod("setLooping", classArray);
            method.invoke(this.controller, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void readMovie(Object object) {
        try {
            if (object instanceof String) {
                String string = (String)object;
                if (string.startsWith("http:")) {
                    try {
                        this.movie = this.readMovieFromURL(new URL(string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new ErrorException("MovieClip: Malformed URL");
                    }
                } else {
                    this.movie = this.readMovieFromFile(new File(string));
                }
            } else if (object instanceof File) {
                this.movie = this.readMovieFromFile((File)object);
            } else if (object instanceof URL) {
                this.movie = this.readMovieFromURL((URL)object);
            }
            this.controller = this.createController();
            this.controllerVisible = true;
            this.addQTComponent(this.controller);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private Object createController() throws Exception {
        Class[] classArray = new Class[]{this.movie.getClass()};
        Object[] objectArray = new Object[]{this.movie};
        Constructor<?> constructor = this.movieControllerClass.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    private void addQTComponent(Object object) throws Exception {
        if (!(object instanceof Component)) {
            Class[] classArray = new Class[]{object.getClass()};
            Object[] objectArray = new Object[]{object};
            Method method = this.qtFactoryClass.getMethod("makeQTComponent", classArray);
            object = method.invoke(null, objectArray);
            if (!(object instanceof Component)) {
                Class<?> clazz = object.getClass();
                Method method2 = clazz.getMethod("asComponent", new Class[0]);
                object = method2.invoke(object, new Object[0]);
            }
        }
        this.removeAll();
        this.add((Component)object, "Center");
    }

    private Object readMovieFromFile(File file) {
        try {
            Class[] classArray = new Class[]{Class.forName("java.io.File")};
            Object[] objectArray = new Object[]{file};
            Constructor<?> constructor = this.qtFileClass.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            Class[] classArray2 = new Class[]{this.qtFileClass};
            Object[] objectArray2 = new Object[]{obj};
            Method method = this.openMovieFileClass.getMethod("asRead", classArray2);
            Object object = method.invoke(null, objectArray2);
            Class[] classArray3 = new Class[]{this.openMovieFileClass};
            Object[] objectArray3 = new Object[]{object};
            Method method2 = this.movieClass.getMethod("fromFile", classArray3);
            return method2.invoke(null, objectArray3);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private Object readMovieFromURL(URL uRL) {
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Object[] objectArray = new Object[]{uRL.toString()};
            Constructor<?> constructor = this.qtDataRefClass.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            Class[] classArray2 = new Class[]{this.qtDataRefClass, Integer.TYPE};
            Object[] objectArray2 = new Object[]{obj, new Integer(0)};
            Method method = this.movieClass.getMethod("fromDataRef", classArray2);
            return method.invoke(null, objectArray2);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setControllerVisible(boolean bl) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        if (bl != this.controllerVisible) {
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Object[] objectArray = new Object[]{new Boolean(bl)};
                Method method = this.movieControllerClass.getMethod("setVisible", classArray);
                method.invoke(this.controller, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
            this.controllerVisible = bl;
        }
    }

    private int getCurrentTime() {
        if (!this.hasQuickTime || this.movie == null) {
            return 0;
        }
        try {
            Method method = this.movieControllerClass.getMethod("getCurrentTime", new Class[0]);
            return (Integer)method.invoke(this.controller, new Object[0]);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setCurrentTime(int n) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{this.timeRecordClass};
            Object[] objectArray = new Object[]{this.createTimeRecord(n)};
            Method method = this.movieControllerClass.getMethod("goToTime", classArray);
            method.invoke(this.controller, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setControllerVolume(double d) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{Float.TYPE};
            Object[] objectArray = new Object[]{new Float((float)d)};
            Method method = this.movieControllerClass.getMethod("setVolume", classArray);
            method.invoke(this.controller, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private void setRate(double d) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] classArray = new Class[]{Float.TYPE};
            Object[] objectArray = new Object[]{new Float((float)d)};
            Method method = this.movieClass.getMethod("setRate", classArray);
            method.invoke(this.movie, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private boolean isStopped() {
        if (!this.hasQuickTime || this.movie == null) {
            return true;
        }
        try {
            Method method = this.movieControllerClass.getMethod("getPlayRate", new Class[0]);
            return (double)((Float)method.invoke(this.controller, new Object[0])).floatValue() == 0.0;
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private int getQTDuration() {
        if (!this.hasQuickTime || this.movie == null) {
            return 0;
        }
        try {
            Method method = this.movieClass.getMethod("getDuration", new Class[0]);
            return (Integer)method.invoke(this.movie, new Object[0]);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private int getQTTimeScale() {
        if (!this.hasQuickTime || this.movie == null) {
            return 600;
        }
        try {
            Method method = this.movieClass.getMethod("getTimeScale", new Class[0]);
            return (Integer)method.invoke(this.movie, new Object[0]);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private Object createTimeRecord(int n) {
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Long.TYPE};
            Object[] objectArray = new Object[]{new Integer(this.getQTTimeScale()), new Long(n)};
            Constructor<?> constructor = this.timeRecordClass.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }
}

