/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.util.ErrorException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import stanford.facepamphlet.FPLoginDialog;
import stanford.facepamphlet.FPPropertyManager;
import stanford.facepamphlet.FPRepository;
import stanford.facepamphlet.FPTools;
import stanford.facepamphlet.FPWizardDialog;

public class FPLocalRepository
implements FPRepository {
    private static final int MAX_LOGIN_ATTEMPTS = 5;
    private String homeId;
    private FPPropertyManager props;

    public FPLocalRepository() {
        this.props = new FPPropertyManager();
        FPLoginDialog dialog = new FPLoginDialog();
        dialog.setTitle("FacePamphlet Login (local)");
        int i = 0;
        while (i < 5) {
            if (!dialog.popupLoginDialog()) {
                System.exit(0);
            }
            this.homeId = dialog.getId();
            if (this.homeId.equals("")) {
                System.exit(0);
            }
            if (!this.props.userExists(this.homeId)) {
                if (dialog.popupCreateDialog()) {
                    this.props.createUser(this.homeId, dialog.getPassword(), dialog.getFullName());
                    if (!this.homeId.equals("cs106a") && this.props.userExists("cs106a")) {
                        this.addFriendLink(this.homeId, "cs106a");
                    }
                } else {
                    this.homeId = null;
                }
            }
            if (this.homeId != null) {
                String password = dialog.getPassword();
                if (password.equals(this.props.getProperty(String.valueOf(this.homeId) + ".password"))) {
                    return;
                }
                dialog.setStatus("Incorrect password");
                dialog.setPassword("");
            }
            ++i;
        }
        System.out.println("Too many attempts");
        System.exit(0);
    }

    @Override
    public String getHomeUserId() {
        return this.homeId;
    }

    @Override
    public String getProperty(String property) {
        FPWizardDialog.addWizardDialog(this);
        if (!this.isReadableBy(property, this.homeId)) {
            throw new ErrorException("You don't have permission to read " + property);
        }
        return this.props.getProperty(property);
    }

    @Override
    public void setProperty(String property, String value) {
        if (!this.isWritableBy(property, this.homeId)) {
            throw new ErrorException("You don't have permission to write " + property);
        }
        this.props.setProperty(property, value);
    }

    @Override
    public void writeWallMessage(String msg, String id) {
        this.checkUser(id);
        if (!this.homeId.equals(id) && !this.areFriends(id, this.homeId)) {
            throw new ErrorException("No permission to write on this wall");
        }
        ArrayList<String> wall = FPTools.splitLines(this.props.getProperty(String.valueOf(id) + ".wall"));
        if (!wall.isEmpty()) {
            wall.add(0, "");
        }
        String date = new SimpleDateFormat("dd-MMM-yyyy HH:mm").format(new Date());
        String sig = this.homeId;
        String fullName = this.props.getProperty(String.valueOf(this.homeId) + ".name");
        if (fullName != null) {
            sig = String.valueOf(fullName) + " <" + this.homeId + ">";
        }
        wall.add(0, "     " + date);
        wall.add(0, "-- " + sig);
        wall.add(0, msg);
        this.props.setProperty(String.valueOf(id) + ".wall", FPTools.combineLines(wall));
    }

    @Override
    public void requestFriend(String id) {
        this.checkUser(id);
        if (this.areFriends(this.homeId, id)) {
            return;
        }
        ArrayList<String> requests = FPTools.splitLines(this.props.getProperty(String.valueOf(id) + ".requests"));
        if (!requests.contains(this.homeId)) {
            requests.add(this.homeId);
        }
        this.props.setProperty(String.valueOf(id) + ".requests", FPTools.combineLines(requests));
    }

    @Override
    public void confirmFriendRequest(String id) {
        this.ignoreFriendRequest(id);
        this.addFriendLink(id, this.homeId);
    }

    @Override
    public void ignoreFriendRequest(String id) {
        this.checkUser(id);
        ArrayList<String> requests = FPTools.splitLines(this.props.getProperty(String.valueOf(this.homeId) + ".requests"));
        requests.remove(id);
        this.props.setProperty(String.valueOf(this.homeId) + ".requests", FPTools.combineLines(requests));
    }

    @Override
    public String[] getUsers() {
        return this.props.getUsers();
    }

    @Override
    public String[] getFriendRequests() {
        String requests = this.getProperty(String.valueOf(this.getHomeUserId()) + ".requests");
        if (requests == null) {
            return new String[0];
        }
        return requests.split("\r\n|\r|\n");
    }

    @Override
    public String[] getMyFriends() {
        String friends = this.getProperty(String.valueOf(this.getHomeUserId()) + ".friends");
        if (friends == null) {
            return new String[0];
        }
        return friends.split("\r\n|\r|\n");
    }

    @Override
    public boolean isMyFriend(String id) {
        String[] stringArray = this.getMyFriends();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            if (id.equals(user)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void close() {
    }

    protected FPLocalRepository(String id, FPPropertyManager propTable) {
        this.homeId = id;
        this.props = propTable;
    }

    protected boolean isReadableBy(String property, String user) {
        int dot = property.indexOf(".");
        if (dot == -1) {
            throw new ErrorException("Invalid property: " + property);
        }
        String id = property.substring(0, dot);
        String key = property.substring(dot + 1);
        if (id.equals(user)) {
            return true;
        }
        if (id.equals("name")) {
            return true;
        }
        if (id.equals("friends")) {
            return true;
        }
        if (id.equals("interests")) {
            return true;
        }
        if (id.startsWith("$")) {
            return true;
        }
        if (key.equals("password")) {
            return false;
        }
        return this.areFriends(id, user);
    }

    protected boolean isWritableBy(String property, String user) {
        int dot = property.indexOf(".");
        if (dot == -1) {
            throw new ErrorException("Invalid property: " + property);
        }
        String id = property.substring(0, dot);
        String key = property.substring(dot + 1);
        if (id.equals(user)) {
            return true;
        }
        if (key.equals("password")) {
            return false;
        }
        return this.areFriends(id, user);
    }

    protected boolean areFriends(String id1, String id2) {
        return FPTools.splitLines(this.props.getProperty(String.valueOf(id1) + ".friends")).contains(id2);
    }

    protected void addFriendLink(String id1, String id2) {
        this.addLink(id1, id2);
        this.addLink(id2, id1);
    }

    private void addLink(String id1, String id2) {
        ArrayList<String> list = FPTools.splitLines(this.props.getProperty(String.valueOf(id1) + ".friends"));
        if (!list.contains(id2)) {
            list.add(id2);
        }
        this.props.setProperty(String.valueOf(id1) + ".friends", FPTools.combineLines(list));
    }

    private void checkUser(String id) {
        if (!this.props.userExists(id)) {
            throw new ErrorException("No such user - " + id);
        }
    }
}

