/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import stanford.facepamphlet.CacheRecord;
import stanford.facepamphlet.FPLoginDialog;
import stanford.facepamphlet.FPRepository;
import stanford.facepamphlet.FPTools;
import stanford.facepamphlet.FPWizardDialog;

public class FPNetworkRepository
implements FPRepository {
    private static final int MAX_LOGIN_ATTEMPTS = 5;
    private HashMap<String, CacheRecord> localCache = new HashMap();
    private Socket socket;
    private BufferedReader netReader;
    private PrintWriter netWriter;
    private String homeId;

    public FPNetworkRepository() {
        FPLoginDialog dialog = new FPLoginDialog();
        int i = 0;
        while (i < 5) {
            if (!dialog.popupLoginDialog()) {
                System.exit(0);
            }
            this.homeId = dialog.getId();
            String password = dialog.getPassword();
            String status = this.initConnectionToServer(this.homeId, password);
            if (status.equals("OK")) {
                return;
            }
            dialog.setPassword("");
            dialog.setStatus(status);
            if (!status.equals("Incorrect password")) {
                dialog.setPassword("");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        System.out.println("Too many attempts");
        System.exit(0);
    }

    @Override
    public String getHomeUserId() {
        return this.homeId;
    }

    @Override
    public String getProperty(String property) {
        long timestamp;
        FPWizardDialog.addWizardDialog(this);
        String value = null;
        CacheRecord cacheEntry = this.localCache.get(property);
        if (cacheEntry != null && cacheEntry.timestamp > (timestamp = this.getLastModifiedTime(property))) {
            return cacheEntry.value;
        }
        this.putLine("getProperty " + property);
        value = FPTools.unpackIntoMultipleLines(this.getLine());
        this.checkResponse();
        if (value != null) {
            if (cacheEntry == null) {
                cacheEntry = new CacheRecord();
                this.localCache.put(property, cacheEntry);
            }
            cacheEntry.value = value;
            cacheEntry.timestamp = this.getSystemTime();
        }
        return value;
    }

    @Override
    public void setProperty(String property, String value) {
        this.putLine("setProperty " + property);
        this.putLine(FPTools.packIntoSingleLine(value));
        this.checkResponse();
    }

    @Override
    public void writeWallMessage(String msg, String id) {
        this.putLine("writeWall " + id);
        this.putLine(FPTools.packIntoSingleLine(msg));
        this.checkResponse();
    }

    @Override
    public void requestFriend(String id) {
        this.putLine("requestFriend " + id);
        this.checkResponse();
    }

    @Override
    public void confirmFriendRequest(String id) {
        this.putLine("confirmFriend " + id);
        this.checkResponse();
    }

    @Override
    public void ignoreFriendRequest(String id) {
        this.putLine("ignoreFriend " + id);
        this.checkResponse();
    }

    @Override
    public String[] getUsers() {
        this.putLine("getUsers");
        String users = FPTools.unpackIntoMultipleLines(this.getLine());
        this.checkResponse();
        if (users == null) {
            throw new ErrorException("Null user list");
        }
        return users.split("\r\n|\r|\n");
    }

    @Override
    public String[] getFriendRequests() {
        String requests = this.getProperty(String.valueOf(this.getHomeUserId()) + ".requests");
        if (requests == null) {
            return new String[0];
        }
        return requests.split("\r\n|\r|\n");
    }

    @Override
    public String[] getMyFriends() {
        String friends = this.getProperty(String.valueOf(this.getHomeUserId()) + ".friends");
        if (friends == null) {
            return new String[0];
        }
        return friends.split("\r\n|\r|\n");
    }

    @Override
    public boolean isMyFriend(String id) {
        String[] stringArray = this.getMyFriends();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            if (id.equals(user)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void close() {
        try {
            this.putLine("closeConnection");
            this.netWriter.close();
            this.netReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected long getSystemTime() {
        this.putLine("getSystemTime");
        long timestamp = Long.parseLong(this.getLine());
        return timestamp;
    }

    protected long getLastModifiedTime(String property) {
        this.putLine("getModifiedTime " + property);
        String line = this.getLine();
        if (line == null) {
            return 0L;
        }
        long timestamp = Long.parseLong(line);
        return timestamp;
    }

    protected String[] getClients() {
        this.putLine("getClients");
        String line = this.getLine();
        if (line == null) {
            return new String[0];
        }
        String[] result = line.split("\u0001");
        this.checkResponse();
        return result;
    }

    protected void stopClient(String id) {
        this.putLine("stopClient " + id);
        this.checkResponse();
    }

    protected void rebootServer() {
        this.putLine("rebootServer");
    }

    private String initConnectionToServer(String id, String password) {
        String result = null;
        int pass = 1;
        while (pass <= 2) {
            try {
                String hostname = pass == 1 ? InetAddress.getLocalHost().getHostName() : "eeyore.stanford.edu";
                this.socket = new Socket(hostname, 1729);
                this.netReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.netWriter = new PrintWriter(this.socket.getOutputStream());
                this.netWriter.println(id);
                this.netWriter.println(password);
                this.netWriter.flush();
                return this.netReader.readLine();
            }
            catch (IOException ex) {
                if (pass == 2) {
                    this.homeId = null;
                    result = ex.getMessage();
                }
                ++pass;
            }
        }
        return result;
    }

    private void putLine(String line) {
        this.netWriter.println(line);
        this.netWriter.flush();
    }

    private String getLine() {
        try {
            return this.netReader.readLine();
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void checkResponse() {
        String msg = this.getLine();
        if (msg == null) {
            msg = "Unexpected null response from server";
        }
        if (!msg.equals("OK")) {
            throw new ErrorException(msg);
        }
    }
}

