/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import stanford.facepamphlet.FPTools;

class FPPropertyManager {
    private File root = this.getRootDirectory();
    private HashMap<String, File> fileMap = new HashMap();

    public String getProperty(String property) {
        File file;
        File file2 = file = this.findPropertyFile(property);
        synchronized (file2) {
            block8: {
                if (file.exists()) break block8;
                return null;
            }
            try {
                String line;
                BufferedReader rd = new BufferedReader(new FileReader(file));
                String value = "";
                while ((line = rd.readLine()) != null) {
                    if (value.length() > 0) {
                        value = String.valueOf(value) + FPTools.LINE_SEPARATOR;
                    }
                    value = String.valueOf(value) + line;
                }
                rd.close();
                return value;
            }
            catch (IOException ex) {
                throw new ErrorException((Exception)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, String value) {
        File file;
        File file2 = file = this.findPropertyFile(property);
        synchronized (file2) {
            try {
                PrintWriter wr = new PrintWriter(new FileWriter(file));
                if (value.length() > 0) {
                    wr.println(value);
                }
                wr.close();
            }
            catch (IOException ex) {
                throw new ErrorException((Exception)ex);
            }
        }
    }

    public long getLastModifiedTime(String property) {
        return this.findPropertyFile(property).lastModified();
    }

    public boolean userExists(String id) {
        return new File(this.root, id).isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(String id, String password, String name) {
        HashMap<String, File> hashMap = this.fileMap;
        synchronized (hashMap) {
            new File(this.root, id).mkdir();
            this.setProperty(String.valueOf(id) + ".password", password);
            this.setProperty(String.valueOf(id) + ".name", name);
        }
    }

    public String[] getUsers() {
        return this.root.list();
    }

    public boolean propertyExists(String property) {
        return this.findPropertyFile(property).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findPropertyFile(String property) {
        File file = this.fileMap.get(property);
        if (file == null) {
            HashMap<String, File> hashMap = this.fileMap;
            synchronized (hashMap) {
                file = this.fileMap.get(property);
                if (file == null) {
                    file = new File(this.root, property.replace('.', '/'));
                    this.fileMap.put(property, file);
                }
            }
        }
        return file;
    }

    private File getRootDirectory() {
        File base;
        String path = System.getProperty("user.dir");
        if (path != null) {
            File dir = new File(path);
            File base2 = new File(dir, "repository");
            if (base2.isDirectory()) {
                return base2;
            }
            if ((dir = dir.getParentFile()) != null && (base2 = new File(dir, "repository")).isDirectory()) {
                return base2;
            }
        }
        if ((path = System.getProperty("user.home")) != null && (base = new File(new File(path), "repository")).isDirectory()) {
            return base;
        }
        throw new ErrorException("No repository directory");
    }
}

