/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import stanford.facepamphlet.FPLocalRepository;
import stanford.facepamphlet.FPLogFile;
import stanford.facepamphlet.FPPropertyManager;
import stanford.facepamphlet.FPServer;
import stanford.facepamphlet.FPTools;

class FPProtocolHandler
implements Runnable {
    private FPServer server;
    private FPLogFile log;
    private FPPropertyManager props;
    private FPLocalRepository repository;
    private Socket socket;
    private BufferedReader netReader;
    private PrintWriter netWriter;
    private String homeId;
    private long lastCommandTime;
    private Thread myThread;

    public FPProtocolHandler(FPServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.log = server.getLogFile();
    }

    @Override
    public void run() {
        this.myThread = Thread.currentThread();
        try {
            this.netReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.netWriter = new PrintWriter(this.socket.getOutputStream());
            int i = 0;
            while (i < 10 && this.homeId == null) {
                this.validateClientIdentity();
                ++i;
            }
            if (this.homeId == null) {
                this.log.println("Killed a validate loop");
            } else {
                this.log.println("Established connection with " + this.homeId);
                this.commandLoop();
            }
            this.netReader.close();
            this.netWriter.close();
            this.socket.close();
            if (this.homeId != null) {
                this.log.println("Closing connection with " + this.homeId);
            }
            this.server.signalCompletion(this);
        }
        catch (IOException ex) {
            System.out.println("Exception: " + ex);
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    public String toString() {
        String str = super.toString();
        int idle = (int)Math.round((double)(System.currentTimeMillis() - this.lastCommandTime) / 1000.0);
        return String.valueOf(str) + " [" + this.homeId + ", idle " + idle + " seconds]";
    }

    private void commandLoop() throws IOException {
        while (true) {
            String arg;
            this.lastCommandTime = System.currentTimeMillis();
            String line = this.getLine();
            if (line == null) break;
            int space = line.indexOf(32);
            String cmd = space == -1 ? line : line.substring(0, space);
            String string = arg = space == -1 ? "" : line.substring(space + 1);
            if (cmd.equals("closeConnection")) break;
            if (cmd.equals("getProperty")) {
                this.executeGetPropertyCommand(arg);
                continue;
            }
            if (cmd.equals("setProperty")) {
                this.executeSetPropertyCommand(arg);
                continue;
            }
            if (cmd.equals("writeWall")) {
                this.executeWriteWallCommand(arg);
                continue;
            }
            if (cmd.equals("requestFriend")) {
                this.executeRequestFriendCommand(arg);
                continue;
            }
            if (cmd.equals("confirmFriend")) {
                this.executeConfirmFriendCommand(arg);
                continue;
            }
            if (cmd.equals("ignoreFriend")) {
                this.executeIgnoreFriendCommand(arg);
                continue;
            }
            if (cmd.equals("getUsers")) {
                this.executeGetUsersCommand();
                continue;
            }
            if (cmd.equals("getClients")) {
                this.executeGetClientsCommand();
                continue;
            }
            if (cmd.equals("stopClient")) {
                this.executeStopClientCommand(arg);
                continue;
            }
            if (cmd.equals("rebootServer")) {
                this.executeRebootServerCommand();
                continue;
            }
            if (cmd.equals("getSystemTime")) {
                this.executeGetSystemTimeCommand();
                continue;
            }
            if (cmd.equals("getModifiedTime")) {
                this.executeGetModifiedTimeCommand(arg);
                continue;
            }
            this.log.println("Unrecognized command: " + line);
        }
    }

    private void executeGetPropertyCommand(String property) {
        String msg = "OK";
        String value = null;
        try {
            value = this.repository.getProperty(property);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(FPTools.packIntoSingleLine(value));
        this.putLine(msg);
    }

    private void executeSetPropertyCommand(String property) {
        String msg = "OK";
        String value = FPTools.unpackIntoMultipleLines(this.getLine());
        try {
            this.repository.setProperty(property, value);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(msg);
    }

    private void executeWriteWallCommand(String id) {
        String msg = "OK";
        String text = FPTools.unpackIntoMultipleLines(this.getLine());
        try {
            this.repository.writeWallMessage(text, id);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(msg);
    }

    private void executeRequestFriendCommand(String id) {
        String msg = "OK";
        try {
            this.repository.requestFriend(id);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(msg);
    }

    private void executeConfirmFriendCommand(String id) {
        String msg = "OK";
        try {
            this.repository.confirmFriendRequest(id);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(msg);
    }

    private void executeIgnoreFriendCommand(String id) {
        String msg = "OK";
        try {
            this.repository.ignoreFriendRequest(id);
        }
        catch (ErrorException ex) {
            msg = ex.getMessage();
        }
        this.putLine(msg);
    }

    private void executeGetUsersCommand() {
        String msg = "OK";
        String[] array = this.props.getUsers();
        if (array == null) {
            array = new String[]{};
            msg = "Null user list";
            this.log.println("Server error : Null user list");
        }
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(array));
        this.putLine(FPTools.packIntoSingleLine(FPTools.combineLines(users)));
        this.putLine(msg);
    }

    private void executeGetClientsCommand() {
        String msg = "OK";
        FPProtocolHandler[] array = this.server.getClients();
        ArrayList<String> clients = new ArrayList<String>();
        int i = 0;
        while (i < array.length) {
            clients.add(array[i].toString());
            ++i;
        }
        this.putLine(FPTools.packIntoSingleLine(FPTools.combineLines(clients)));
        this.putLine(msg);
    }

    private void executeStopClientCommand(String connection) {
        this.server.stop(connection);
        this.putLine("OK");
    }

    private void executeRebootServerCommand() {
        this.log.println("Server rebooted by " + this.homeId);
        System.exit(0);
    }

    private void executeGetSystemTimeCommand() {
        this.putLine(Long.toString(System.currentTimeMillis()));
    }

    private void executeGetModifiedTimeCommand(String property) {
        this.putLine(Long.toString(this.props.getLastModifiedTime(property)));
    }

    private void validateClientIdentity() {
        String status = "OK";
        this.homeId = this.getLine();
        if (this.homeId == null) {
            return;
        }
        String password = this.getLine();
        this.props = this.server.getPropertyTable();
        if (!this.props.userExists(this.homeId)) {
            status = "Unknown user id";
            this.homeId = null;
        } else if (password.equals(this.props.getProperty(String.valueOf(this.homeId) + ".password"))) {
            this.repository = new FPLocalRepository(this.homeId, this.props);
        } else {
            status = "Incorrect password";
            this.homeId = null;
        }
        this.netWriter.println(status);
        this.netWriter.flush();
    }

    private void putLine(String line) {
        this.netWriter.println(line);
        this.netWriter.flush();
    }

    private String getLine() {
        try {
            return this.netReader.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

