/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import stanford.facepamphlet.FPScrollableListListener;

public class FPScrollableList
extends JPanel {
    private static final int PREFERRED_WIDTH = 175;
    private static final int PREFERRED_HEIGHT = 90;
    private JList list = new JList();
    private JScrollPane scrollPane;
    private DefaultListModel model = new DefaultListModel();
    private ActionListener actionListener;
    private String actionCommand;

    public FPScrollableList() {
        this.list.setModel(this.model);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new FPScrollableListListener(this));
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.setPreferredSize(new Dimension(175, 90));
    }

    public void clear() {
        this.model.clear();
        this.list.repaint();
    }

    public void add(String name) {
        this.model.addElement(name);
        this.list.repaint();
    }

    public String getSelectedName() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return (String)this.model.get(index);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void fireActionListeners() {
        ActionEvent event = new ActionEvent(this, 1001, this.actionCommand);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }
}

