/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import stanford.facepamphlet.FPLogFile;
import stanford.facepamphlet.FPPropertyManager;
import stanford.facepamphlet.FPProtocolHandler;

public class FPServer {
    public static final int SERVER_SOCKET = 1729;
    public static final String SERVER_REPOSITORY = "../repository/";
    public static final String SERVER_HOSTNAME = "eeyore.stanford.edu";
    public static final String LOG_FILE = "server.log";
    public static final int MAX_THREADS = 15;
    private FPLogFile log;
    private FPPropertyManager props;
    private ArrayList<FPProtocolHandler> clients;

    public static void main(String[] args) {
        new FPServer().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log = new FPLogFile(LOG_FILE);
        this.props = new FPPropertyManager();
        this.clients = new ArrayList();
        while (true) {
            try {
                block8: while (true) {
                    String hostname = InetAddress.getLocalHost().getHostName();
                    this.log.println("Starting server on " + hostname + ":" + 1729);
                    ServerSocket serverSocket = new ServerSocket(1729);
                    while (true) {
                        Socket clientSocket = serverSocket.accept();
                        this.log.println("" + clientSocket);
                        if (this.clients.size() > 15) {
                            this.cleanupNullThreads();
                            if (this.clients.size() > 15) {
                                clientSocket.close();
                                continue block8;
                            }
                        }
                        FPProtocolHandler handler = new FPProtocolHandler(this, clientSocket);
                        ArrayList<FPProtocolHandler> arrayList = this.clients;
                        synchronized (arrayList) {
                            this.clients.add(handler);
                        }
                        new Thread(handler).start();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
            }
            catch (IOException ex) {
                System.out.println("main: " + ex);
                continue;
            }
            break;
        }
    }

    public FPLogFile getLogFile() {
        return this.log;
    }

    public FPPropertyManager getPropertyTable() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalCompletion(FPProtocolHandler handler) {
        ArrayList<FPProtocolHandler> arrayList = this.clients;
        synchronized (arrayList) {
            this.clients.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FPProtocolHandler[] getClients() {
        ArrayList<FPProtocolHandler> arrayList = this.clients;
        synchronized (arrayList) {
            FPProtocolHandler[] array = new FPProtocolHandler[this.clients.size()];
            this.clients.toArray(array);
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String connection) {
        String clientAddress = this.extractHandlerAddress(connection);
        FPProtocolHandler target = null;
        FPServer fPServer = this;
        synchronized (fPServer) {
            FPProtocolHandler[] clients = this.getClients();
            int i = 0;
            while (i < clients.length && target == null) {
                if (clientAddress.equalsIgnoreCase(this.extractHandlerAddress(clients[i].toString()))) {
                    target = clients[i];
                }
                ++i;
            }
        }
        if (target == null) {
            this.log.println("No handler for address 0x" + clientAddress.toUpperCase());
        } else {
            try {
                Class<?> threadClass = Class.forName("java.lang.Thread");
                Thread targetThread = target.getThread();
                threadClass.getMethod("stop", new Class[0]).invoke((Object)targetThread, new Object[0]);
                this.signalCompletion(target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupNullThreads() {
        FPServer fPServer = this;
        synchronized (fPServer) {
            FPProtocolHandler[] fPProtocolHandlerArray = this.getClients();
            int n = fPProtocolHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FPProtocolHandler handler = fPProtocolHandlerArray[n2];
                String str = handler.toString();
                if (str.indexOf("null") >= 0) {
                    this.stop(str);
                }
                ++n2;
            }
        }
    }

    private String extractHandlerAddress(String connection) {
        int at = connection.indexOf(64);
        int space = connection.indexOf(32, at + 1);
        if (space == -1) {
            space = connection.length();
        }
        return connection.substring(at + 1, space);
    }
}

