/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.graphics.GImage;
import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Image;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class FPTools {
    protected static final String VALID_KEY_CHARS = ".-_$";
    protected static final String LINE_BOUNDARY_PATTERN = "\r\n|\r|\n";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String PACKED_SEPARATOR = "\u0001";
    protected static final String NULL_MARKER = "\u0002";
    protected static final int MAX_IMAGE_SIZE = 250000;

    private FPTools() {
    }

    public static String convertGImageToString(GImage image) {
        return FPTools.convertImageToString(image.getImage());
    }

    public static GImage convertStringToGImage(String str) {
        return new GImage(FPTools.convertStringToImage(str));
    }

    protected static String convertImageToString(Image image) {
        int height;
        if (image == null) {
            return null;
        }
        int[][] pixels = MediaTools.getPixelArray((Image)image);
        int width = pixels[0].length;
        if (width * (height = pixels.length) > 250000) {
            throw new ErrorException("Image size too large");
        }
        StringWriter wr = new StringWriter();
        wr.write(String.valueOf(width) + "x" + height + ":");
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                String hex = Integer.toHexString(pixels[i][j]);
                while (hex.length() < 8) {
                    hex = "0" + hex;
                }
                wr.write(hex.toUpperCase());
                ++j;
            }
            ++i;
        }
        return wr.toString();
    }

    protected static Image convertStringToImage(String str) {
        int colon;
        int xp;
        block6: {
            xp = str.indexOf(120);
            colon = str.indexOf(58);
            if (xp != -1 && colon != -1) break block6;
            return null;
        }
        try {
            int width = Integer.parseInt(str.substring(0, xp));
            int height = Integer.parseInt(str.substring(xp + 1, colon));
            int[][] pixels = new int[height][width];
            int index = colon + 1;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pixel = 0;
                    int k = 0;
                    while (k < 8) {
                        pixel = pixel << 4 | Character.digit(str.charAt(index++), 16);
                        ++k;
                    }
                    pixels[i][j] = pixel;
                    ++j;
                }
                ++i;
            }
            return MediaTools.createImage((int[][])pixels);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    protected static String packIntoSingleLine(String str) {
        if (str == null) {
            return NULL_MARKER;
        }
        StringWriter wr = new StringWriter();
        String[] lines = str.split(LINE_BOUNDARY_PATTERN, -1);
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                wr.write(PACKED_SEPARATOR);
            }
            wr.write(lines[i]);
            ++i;
        }
        return wr.toString();
    }

    protected static String unpackIntoMultipleLines(String str) {
        if (str == null || str.equals(NULL_MARKER)) {
            return null;
        }
        StringWriter wr = new StringWriter();
        String[] lines = str.split(PACKED_SEPARATOR, -1);
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                wr.write(LINE_SEPARATOR);
            }
            wr.write(lines[i]);
            ++i;
        }
        return wr.toString();
    }

    protected static ArrayList<String> splitLines(String str) {
        if (str == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(str.split(LINE_BOUNDARY_PATTERN, -1)));
    }

    protected static String combineLines(ArrayList<String> list) {
        String result = "";
        boolean started = false;
        for (String line : list) {
            if (started) {
                result = String.valueOf(result) + LINE_SEPARATOR;
            }
            result = String.valueOf(result) + line;
            started = true;
        }
        return result;
    }

    protected static boolean keyIsValid(String key) {
        int i = 0;
        while (i < key.length()) {
            char ch = key.charAt(i);
            if (VALID_KEY_CHARS.indexOf(ch) == -1 && !Character.isLetterOrDigit(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

