/*
 * Decompiled with CFR 0.152.
 */
package stanford.facepamphlet;

import acm.program.Program;
import acm.util.JTFTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import stanford.facepamphlet.FPNetworkRepository;
import stanford.facepamphlet.FPRepository;

class FPWizardDialog
extends JDialog
implements ActionListener,
MouseListener {
    private static final String DIALOG_TITLE = "FacePamphlet Debugging Wizard";
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 350;
    private static boolean westPanelFixed = false;
    private static boolean eastPanelFixed = false;
    private static FPWizardDialog wizardDialog;
    private FPNetworkRepository repository;
    private JList list;
    private DefaultListModel model;

    public FPWizardDialog(FPNetworkRepository repository) {
        super(JTFTools.getEnclosingFrame((Component)JTFTools.getApplet()), DIALOG_TITLE, true);
        this.repository = repository;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.list = new JList();
        this.model = new DefaultListModel();
        this.list.setModel(this.model);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(this.createButton("Clients"));
        buttons.add(this.createButton("Reboot"));
        buttons.add(this.createButton("Close"));
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttons, "South");
        this.setSize(500, 350);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void addWizardDialog(FPRepository repository) {
        JPanel panel2;
        Program program = (Program)JTFTools.getApplet();
        if (program == null) {
            return;
        }
        if (!westPanelFixed) {
            try {
                panel2 = program.getRegionPanel("West");
                westPanelFixed = FPWizardDialog.fixTextFieldSizes(panel2);
                if (westPanelFixed && repository instanceof FPNetworkRepository) {
                    wizardDialog = new FPWizardDialog((FPNetworkRepository)repository);
                    panel2.addMouseListener(wizardDialog);
                }
            }
            catch (Exception panel2) {
                // empty catch block
            }
        }
        if (!eastPanelFixed) {
            try {
                panel2 = program.getRegionPanel("East");
                eastPanelFixed = FPWizardDialog.fixTextFieldSizes(panel2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean fixTextFieldSizes(Container panel) {
        if (!panel.isShowing() || panel.getComponentCount() == 0) {
            return false;
        }
        Component[] componentArray = panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JTextField) {
                Dimension size = comp.getPreferredSize();
                if (size.width == 0 && size.height == 0) {
                    return false;
                }
                comp.setPreferredSize(size);
            } else {
                comp.setSize(comp.getSize());
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Clients")) {
            this.setListContents(this.repository.getClients());
        } else if (cmd.equals("Reboot")) {
            this.repository.rebootServer();
        } else if (cmd.equals("Close")) {
            this.setVisible(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.list) {
            if (e.getClickCount() >= 2) {
                String selected = (String)this.list.getSelectedValue();
                if (selected != null) {
                    this.repository.stopClient(selected);
                }
                this.setListContents(this.repository.getClients());
            }
        } else if (e.getX() < 10 && e.getY() < 10 && e.isShiftDown() && e.isAltDown()) {
            this.model.clear();
            this.setVisible(true);
        }
    }

    private JButton createButton(String name) {
        JButton button = new JButton(name);
        button.addActionListener(this);
        return button;
    }

    private void setListContents(String[] array) {
        this.model.clear();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.model.addElement(str);
            ++n2;
        }
    }
}

