/*
 * File: FacePamphlet.java
 * -----------------------
 * This is the starter file for Assignment #5, in which you get to
 * implement FacePamphlet -- a simple social networking application.
 */

import java.awt.event.ActionEvent;

import acm.program.*;
import stanford.facepamphlet.*;
import javax.swing.*;
import acm.graphics.*;
import acm.util.*;

public class FacePamphlet extends GraphicsProgram implements FPConstants {

/* Initializes the application */

	private static final String FILE_NAME = ".name";
	private static final String FILE_IMAGE = ".image";
	private static final String FILE_STATUS = ".status";
	private static final String FILE_FRIENDS = ".friends";
	private static final String FILE_REQUESTS = ".requests";
	private static final String FILE_WALL = ".wall";
	private static final String FILE_LOG = ".lastaction";
	private static final String STATUSSTRING = "STATUSUPDATE";
	private static final String VISIT = "VISIT";
	private static final String IMAGEBOX = "IMAGEBOX";
	private static final String FRIENDREQUEST = "FRIENDREQUEST";
	private static final String PENDINGFRIENDS = "PENDINGFRIENDS";
	private static final String USERWALL = "USERWALL";
	private static final int CENTERWIDTH = 450;
	
	public void init() {
		repository = new FPLocalRepository();
		
		this.setBounds(0, 0, FPConstants.APPLICATION_WIDTH, FPConstants.APPLICATION_HEIGHT);
		// You fill in the rest
		homeUserID = repository.getHomeUserId();
		// linkingUserId is used to update the screen, with either the homeuser or linked user
		linkingUserID = homeUserID;
		
		// need to update
		initWestPanel(homeUserID);
		initEastPanel(homeUserID);
		initCenter(homeUserID);
		
		addActionListeners();
		
	}
	
	public void actionPerformed(ActionEvent event)
	{
		String Message = new String();
		
		if ((event.getSource() == changeStatus) || (event.getActionCommand().equals(STATUSSTRING)))
		{
			if (statusBox.getText().length() > 0)
			{
				try {
					repository.setProperty(homeUserID + FILE_STATUS, statusBox.getText());
					repository.setProperty(homeUserID + FILE_LOG, "Status updated : " + statusBox.getText());
				} catch (ErrorException ex)
				{
					Message = "Error updating the status : "+ex.getMessage();
				}
			}
			statusBox.setText("");
			linkingUserID = homeUserID;
		}
		
		if ((event.getSource() == changeImage) || (event.getActionCommand().equals(IMAGEBOX)))
		{
			try {
				GImage thePic = new GImage("images/"+imageBox.getText());
				if (thePic != null)
				{
					repository.setProperty(homeUserID + FILE_IMAGE, FPTools.convertGImageToString(thePic));
					repository.setProperty(homeUserID + FILE_LOG, "Saved image : "+ imageBox.getText() + " Image Height = "+ thePic.getHeight() + " Max height = "+ FPConstants.MAX_IMAGE_HEIGHT);
				}
				else
					repository.setProperty(homeUserID + FILE_LOG, "not able to open file : " + imageBox.getText());;
			} catch (ErrorException ex)
			{
				// picture not found!!
				repository.setProperty(homeUserID + FILE_LOG, "not able to open file : " + imageBox.getText());;
				Message = "Cannot find picture in images/"+imageBox.getText();
			}
			imageBox.setText("");
			linkingUserID = homeUserID;
		}
		if ((event.getSource() == userWallSend) || event.getActionCommand().equals(USERWALL))
		{
			String theMessage = userWallText.getText();
			if (theMessage.length() > 0)
			{
				try {
					repository.writeWallMessage(theMessage, linkingUserID);
				}
				catch (ErrorException ex)
				{
					Message = "Error updating wall messages : " + ex.getMessage();
				}
				repository.setProperty(homeUserID + FILE_LOG , "updated " + linkingUserID + " wall with message "+theMessage);
			}
			userWallText.setText("");
		}
		if (event.getSource() ==usersName)
		{
			linkingUserID = homeUserID;
			repository.setProperty(homeUserID + FILE_LOG , "back to home page");
		}
		// friendslist 
		if ((event.getActionCommand().equals(VISIT)) || event.getSource() == visit)
		{
			String selectedName=new String();
			try {
				selectedName = friendsList.getSelectedName();
				if (selectedName.length() > 0)
					linkingUserID = selectedName;
				else
					linkingUserID = homeUserID;
			} catch (ErrorException ex)  
			{
				Message = "No user selected ? Error updating " + ex.getMessage();
			}
			
		}
		if ((event.getSource() == friendRequestButton) || event.getActionCommand().equals(FRIENDREQUEST))
		{
			String requested = friendRequest.getText();
			if (requested.length() > 0)
			{
				try 
				{
					if (repository.isMyFriend(requested))
						Message = requested + " is already your friend";
					else
					{
						repository.requestFriend(requested);
						Message = "Requested friend : " + requested;
					}
					repository.setProperty(homeUserID + FILE_LOG , "Requested friend " + requested);
				}
				catch (NullPointerException ex)
				{
					Message = "Not sure of name ? "+ requested + " : error : "+ ex.getMessage();
				}
				catch (ErrorException ex)
				{
					Message = "Not sure of name ? "+ requested + " : error : "+ ex.getMessage();
				}
			}
			friendRequest.setText("");
		}
		if ((event.getActionCommand().equals(PENDINGFRIENDS)) || event.getSource() == friendsPendingButton)
		{
			try {
				String requested = pendingFriendsList.getSelectedName();
				if (requested.length()> 0)
				{
					repository.confirmFriendRequest(requested);
				}
				repository.setProperty(homeUserID + FILE_LOG , "Confirmed friend " + requested);
				Message = "Confirmed friend "+ requested;
			} catch (NullPointerException ex)  
			{
				Message = "No user selected ? Error : "+ ex.getMessage();
			}
		}
		if (event.getSource() == friendsIgnoreButton)
		{
			try {
				String requested = pendingFriendsList.getSelectedName();
				if (requested.length()> 0)
				{
					repository.ignoreFriendRequest(requested);
				}
				repository.setProperty(homeUserID + FILE_LOG , "Ignore friend " + requested);
				Message = "Ignored friend "+requested;
			} catch (NullPointerException ex)  
			{
				Message = "No user selected ? error : " + ex.getMessage();
			}
		}
		update(Message);
	}

	// update all of the areas that may need some updating
	// pending friends, walls etc.
	private void update(String message)
	{
		initCenter(linkingUserID);
		updateEastPanel(linkingUserID);
		String newMessage = updateWestPanel();
		// error messages override the you have a new friend message.
		if (message.equals("")) message = newMessage;
		updateErrorMessage(message);
	}

	private String updateWestPanel()
	{
		String message = new String();
		friendsList.clear();
		String[] myFriendsNew = repository.getMyFriends();
		int myFriendsLength = myFriends.length;
		for (int i=0; i < myFriendsNew.length; i++)
		{
			friendsList.add(myFriendsNew[i]);
			if (myFriendsLength <= i)
			{
				message += myFriendsNew[i]+",";
			}
		}
		if (myFriendsLength < myFriendsNew.length)
		{
			message = "You are now friends with " + message.substring(0, message.length()-1);
		}
		myFriends = myFriendsNew;
		
		pendingFriendsList.clear();
		String[] friendsRequest = repository.getFriendRequests();
		for (int i =0; i < friendsRequest.length; i++)
			pendingFriendsList.add(friendsRequest[i]);
		return message;
	}
	
	// initcenter does init the center and also does perform the updates
	private void initCenter(String usersID)
	{
		String userName = repository.getProperty(usersID + FILE_NAME);
		if (userName != null)
		{
			if (nameCentre != null) remove(nameCentre);
			nameCentre = new GLabel(userName);
			nameCentre.setFont(FPConstants.NAME_FONT);
			nameCentre.setLocation(FPConstants.LEFT_MARGIN,FPConstants.TOP_MARGIN);
			add(nameCentre);
			
			if (picCentre !=null) remove(picCentre);
			String thePicString = repository.getProperty(usersID + FILE_IMAGE);
			if (thePicString != null)
			{
				picCentre = FPTools.convertStringToGImage(thePicString);
				if (picCentre.getHeight() > FPConstants.MAX_IMAGE_HEIGHT)
				{
					double newHeight = FPConstants.MAX_IMAGE_HEIGHT / picCentre.getHeight();
					picCentre.scale(newHeight);
				}
				if (picCentre.getWidth() > CENTERWIDTH)
				{
					double newWidth = CENTERWIDTH/ picCentre.getWidth();
					picCentre.scale(newWidth);
				}
				picCentre.setLocation(FPConstants.LEFT_MARGIN, FPConstants.IMAGE_TOP);
				add(picCentre);
			}
			
			if (statusCentre != null) remove(statusCentre);
			String theStatus = repository.getProperty(usersID + FILE_STATUS);
			if (theStatus != null)
			{
				statusCentre = new GLabel(usersID + " is " + theStatus);
				statusCentre.setLocation(FPConstants.LEFT_MARGIN, FPConstants.STATUS_TOP);
				statusCentre.setFont(FPConstants.STATUS_FONT);
				add(statusCentre);
			}
		}
	}

	private void updateEastPanel(String userID)
	{
		userEastName.setText(userID + "'s wall");
		userWall.setText(repository.getProperty(userID +FILE_WALL));
		userWallText.setText("");
		userEastWallName.setText("Write on " + userID + "'s wall");
	}
	
	private void updateErrorMessage(String message)
	{
		if (infoMessage !=null) remove(infoMessage);
		infoMessage = new GLabel(message);
		infoMessage.setFont(FPConstants.INFO_MESSAGE_FONT);
		infoMessage.setColor(FPConstants.INFO_MESSAGE_COLOR);
		infoMessage.setLocation(FPConstants.LEFT_MARGIN, FPConstants.APPLICATION_HEIGHT - FPConstants.BOTTOM_MARGIN);
		add(infoMessage);
	}
	
	private void initEastPanel(String userID)
	{
		userEastName = new JLabel(userID + "'s wall",JLabel.CENTER);
		add( userEastName, EAST);
		// need to pull back from data from the users wall file
		if (userWall != null) remove (userWall);
		
		userWall = new FPScrollableTextArea();
		String wallMessages = repository.getProperty(userID +FILE_WALL);
		if (wallMessages != null)
			userWall.setText(wallMessages);
		add (userWall, EAST, "weighty=1");
		
		userEastWallName = new JLabel("Write on " + userID + "'s wall", JLabel.CENTER); 
		add( userEastWallName ,EAST);
		userWallText = new JTextField();
		userWallText.addActionListener(this);
		userWallText.setActionCommand(USERWALL);
		
		add (userWallText, EAST);
		userWallSend = new JButton("Send");
		add (userWallSend, EAST);
	}
	
	private void initWestPanel(String userID)
	{
		usersName = new JButton(repository.getProperty(userID + FILE_NAME));
		add(usersName, WEST);
		
		friendsList = new FPScrollableList();
		// add to the friends list
		myFriends = repository.getMyFriends();
		for (int i=0; i < myFriends.length; i++)
			friendsList.add(myFriends[i]);
		add(new JLabel("Friends:"), WEST);
		add(friendsList,WEST);
		
		visit = new JButton("Visit");
		add(visit, WEST);
		
		friendsList.addActionListener(this);
		friendsList.setActionCommand(VISIT);
		
		
		add( new JLabel("Send a friend request:"),WEST);
		friendRequest = new JTextField();
		add(friendRequest, WEST);
		friendRequest.addActionListener(this);
		friendRequest.setActionCommand(FRIENDREQUEST);
		
		friendRequestButton = new JButton("Request");
		add(friendRequestButton, WEST);
		
		add (new JLabel("Pending friend requests:"),WEST);
		pendingFriendsList = new FPScrollableList();
		// add any friend requests
		String[] friendsRequest = repository.getFriendRequests();
		for (int i =0; i < friendsRequest.length; i++)
			pendingFriendsList.add(friendsRequest[i]);
		pendingFriendsList.addActionListener(this);
		pendingFriendsList.setActionCommand(PENDINGFRIENDS);
		
		add (pendingFriendsList, WEST);
		friendsPendingButton = new JButton("Confirm");
		add (friendsPendingButton, WEST);
		friendsIgnoreButton = new JButton("Ignore");
		add (friendsIgnoreButton, WEST);
		
		add (new JLabel("Status:"),WEST);
		statusBox = new JTextField();
		add (statusBox, WEST);
		statusBox.addActionListener(this);
		statusBox.setActionCommand(STATUSSTRING);
		
		changeStatus = new JButton("Change my status");
		add (changeStatus, WEST);
		
		add( new JLabel("Image:"),WEST);
		imageBox = new JTextField();
		add (imageBox, WEST);
		imageBox.addActionListener(this);
		imageBox.setActionCommand(IMAGEBOX);
		
		changeImage = new JButton("Change My Image");
		add (changeImage, WEST);
	}
/* Instance variables */
	private FPRepository repository;

	// west wing
	private String homeUserID;
	private JButton usersName, visit, friendRequestButton, friendsPendingButton;
	private JButton friendsIgnoreButton, changeStatus, changeImage;
	private FPScrollableList friendsList, pendingFriendsList;
	private JTextField friendRequest, statusBox, imageBox;
	
	// east wing
	private JButton userWallSend;
	private JTextField userWallText;
	private FPScrollableTextArea userWall;
	private JLabel userEastName, userEastWallName; 
	
	// centre
	private GLabel statusCentre, nameCentre;
	private GImage picCentre;
	
	private String linkingUserID; // starts with the homeUserID;
	private String[] myFriends;
	
	private GLabel infoMessage;
}
